/*
 * Decompiled with CFR 0.152.
 */
package com.macfaq.xml;

import com.macfaq.xml.CircularIncludeException;
import com.macfaq.xml.EncodingHeuristics;
import com.macfaq.xml.UnavailableResourceException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public final class XIncludeFilter
extends XMLFilterImpl {
    public static final String XINCLUDE_NAMESPACE = "http://www.w3.org/2001/XInclude";
    private Stack bases = new Stack();
    private Stack locators = new Stack();
    private int level = 0;
    private int depth = 0;

    public void setDocumentLocator(Locator locator) {
        this.locators.push(locator);
        String string = locator.getSystemId();
        try {
            this.bases.push(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new UnsupportedOperationException("Unrecognized SYSTEM ID: " + string);
        }
        super.setDocumentLocator(locator);
    }

    public boolean insideIncludeElement() {
        return this.level != 0;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.level == 0) {
            URL uRL;
            String string4 = attributes.getValue("http://www.w3.org/XML/1998/namespace", "base");
            URL uRL2 = uRL = (URL)this.bases.peek();
            if (string4 != null) {
                try {
                    uRL2 = new URL(uRL, string4);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new SAXException("Malformed base URL: " + uRL2, malformedURLException);
                }
            }
            this.bases.push(uRL2);
            if (string.equals(XINCLUDE_NAMESPACE) && string2.equals("include")) {
                String string5 = attributes.getValue("href");
                if (string5 == null) {
                    throw new SAXException("Missing href attribute");
                }
                String string6 = attributes.getValue("parse");
                if (string6 == null) {
                    string6 = "xml";
                }
                if (string6.equals("text")) {
                    String string7 = attributes.getValue("encoding");
                    this.includeTextDocument(string5, string7);
                } else if (string6.equals("xml")) {
                    this.includeXMLDocument(string5);
                } else {
                    throw new SAXException("Illegal value for parse attribute: " + string6);
                }
                ++this.level;
            } else {
                super.startElement(string, string2, string3, attributes);
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string.equals(XINCLUDE_NAMESPACE) && string2.equals("include")) {
            --this.level;
        } else if (this.level == 0) {
            this.bases.pop();
            super.endElement(string, string2, string3);
        }
    }

    public void startDocument() throws SAXException {
        this.level = 0;
        if (this.depth == 0) {
            super.startDocument();
        }
        ++this.depth;
    }

    public void endDocument() throws SAXException {
        this.locators.pop();
        --this.depth;
        if (this.depth == 0) {
            super.endDocument();
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.level == 0) {
            super.startPrefixMapping(string, string2);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
        if (this.level == 0) {
            super.endPrefixMapping(string);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.level == 0) {
            super.characters(cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.level == 0) {
            super.ignorableWhitespace(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.level == 0) {
            super.processingInstruction(string, string2);
        }
    }

    public void skippedEntity(String string) throws SAXException {
        if (this.level == 0) {
            super.skippedEntity(string);
        }
    }

    private String getLocation() {
        String string = "";
        Locator locator = (Locator)this.locators.peek();
        String string2 = "";
        String string3 = "";
        int n = -1;
        int n2 = -1;
        if (locator != null) {
            string2 = locator.getPublicId();
            string3 = locator.getSystemId();
            n2 = locator.getLineNumber();
            n = locator.getColumnNumber();
        }
        string = " in document included from " + string2 + " at " + string3 + " at line " + n2 + ", column " + n;
        return string;
    }

    private void includeTextDocument(String string, String string2) throws SAXException {
        URL uRL;
        Object object;
        if (string2 == null || string2.trim().equals("")) {
            string2 = "UTF-8";
        }
        try {
            object = (URL)this.bases.peek();
            uRL = new URL((URL)object, string);
        }
        catch (MalformedURLException malformedURLException) {
            UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Unresolvable URL " + string + this.getLocation());
            unavailableResourceException.setRootCause(malformedURLException);
            throw new SAXException("Unresolvable URL " + string + this.getLocation(), unavailableResourceException);
        }
        try {
            int n;
            object = uRL.openConnection();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(((URLConnection)object).getInputStream());
            String string3 = ((URLConnection)object).getContentEncoding();
            String string4 = ((URLConnection)object).getContentType();
            if (string3 != null) {
                string2 = string3;
            } else if (string4 != null && ((string4 = string4.toLowerCase()).equals("text/xml") || string4.equals("application/xml") || string4.startsWith("text/") && string4.endsWith("+xml") || string4.startsWith("application/") && string4.endsWith("+xml"))) {
                string2 = EncodingHeuristics.readEncodingFromStream(bufferedInputStream);
            }
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, string2);
            char[] cArray = new char[1024];
            while ((n = inputStreamReader.read(cArray, 0, 1024)) != -1) {
                if (n <= 0) continue;
                this.characters(cArray, 0, n);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SAXException("Unsupported encoding: " + string2 + this.getLocation(), unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new SAXException("Document not found: " + uRL.toExternalForm() + this.getLocation(), iOException);
        }
    }

    private void includeXMLDocument(String string) throws SAXException {
        URL uRL;
        Object object;
        try {
            object = (URL)this.bases.peek();
            uRL = new URL((URL)object, string);
        }
        catch (MalformedURLException malformedURLException) {
            UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Unresolvable URL " + string + this.getLocation());
            unavailableResourceException.setRootCause(malformedURLException);
            throw new SAXException("Unresolvable URL " + string + this.getLocation(), unavailableResourceException);
        }
        try {
            try {
                object = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException sAXException) {
                try {
                    object = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                }
                catch (SAXException sAXException2) {
                    System.err.println("Could not find an XML parser");
                    return;
                }
            }
            object.setContentHandler(this);
            int n = this.level;
            this.level = 0;
            if (this.bases.contains(uRL)) {
                CircularIncludeException circularIncludeException = new CircularIncludeException("Circular XInclude Reference to " + uRL + this.getLocation());
                throw new SAXException("Circular XInclude Reference", circularIncludeException);
            }
            this.bases.push(uRL);
            object.parse(uRL.toExternalForm());
            this.level = n;
            this.bases.pop();
        }
        catch (IOException iOException) {
            throw new SAXException("Document not found: " + uRL.toExternalForm() + this.getLocation(), iOException);
        }
    }
}

