/*
 * Decompiled with CFR 0.152.
 */
package com.macfaq.xml;

import com.macfaq.xml.XIncludeFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXXIncluder
implements ContentHandler,
LexicalHandler {
    private Writer out;
    private String encoding;
    private boolean inDTD = false;
    private Stack entities = new Stack();
    private XIncludeFilter filter = null;

    public SAXXIncluder(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this.out = new OutputStreamWriter(outputStream, string);
        this.encoding = string;
    }

    public SAXXIncluder(OutputStream outputStream) {
        try {
            this.out = new OutputStreamWriter(outputStream, "UTF8");
            this.encoding = "UTF-8";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        try {
            this.out.write("<?xml version='1.0' encoding='" + this.encoding + "'?>\r\n");
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new SAXException("Flush failed", iOException);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            this.out.write("<" + string3);
            int n = 0;
            while (n < attributes.getLength()) {
                this.out.write(" ");
                this.out.write(attributes.getQName(n));
                this.out.write("='");
                String string4 = attributes.getValue(n);
                StringBuffer stringBuffer = new StringBuffer(string4.length() + 4);
                int n2 = 0;
                while (n2 < string4.length()) {
                    char c = string4.charAt(n2);
                    if (c == '&') {
                        stringBuffer.append("&amp;");
                    } else if (c == '<') {
                        stringBuffer.append("&lt;");
                    } else if (c == '>') {
                        stringBuffer.append("&gt;");
                    } else if (c == '\'') {
                        stringBuffer.append("&apos;");
                    } else {
                        stringBuffer.append(c);
                    }
                    ++n2;
                }
                this.out.write(stringBuffer.toString());
                this.out.write("'");
                ++n;
            }
            this.out.write(">");
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.out.write("</" + string3 + ">");
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            int n3 = 0;
            while (n3 < n2) {
                char c = cArray[n + n3];
                if (c == '&') {
                    this.out.write("&amp;");
                } else if (c == '<') {
                    this.out.write("&lt;");
                } else {
                    this.out.write(c);
                }
                ++n3;
            }
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            this.out.write("<?" + string + " " + string2 + "?>");
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    public void skippedEntity(String string) throws SAXException {
        try {
            this.out.write("&" + string + ";");
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.inDTD = true;
        if (this.entities.size() == 0) {
            String string4 = string2 != null ? "PUBLIC \"" + string2 + "\" \"" + string3 + '\"' : "SYSTEM \"" + string3 + '\"';
            try {
                this.out.write("<!DOCTYPE " + string + " " + string4 + ">\r\n");
            }
            catch (IOException iOException) {
                throw new SAXException("Error while writing DOCTYPE", iOException);
            }
        }
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
        this.entities.push(string);
    }

    public void endEntity(String string) throws SAXException {
        this.entities.pop();
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void setFilter(XIncludeFilter xIncludeFilter) {
        this.filter = xIncludeFilter;
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (!this.inDTD && !this.filter.insideIncludeElement()) {
            try {
                this.out.write("<!--");
                this.out.write(cArray, n, n2);
                this.out.write("-->");
            }
            catch (IOException iOException) {
                throw new SAXException("Write failed", iOException);
            }
        }
    }

    public static void main(String[] stringArray) {
        XMLReader xMLReader;
        try {
            xMLReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            try {
                xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            }
            catch (SAXException sAXException2) {
                System.err.println("Could not find an XML parser");
                return;
            }
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXException sAXException) {
            System.err.println(sAXException);
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            try {
                XIncludeFilter xIncludeFilter = new XIncludeFilter();
                xIncludeFilter.setParent(xMLReader);
                SAXXIncluder sAXXIncluder = new SAXXIncluder(System.out);
                xIncludeFilter.setContentHandler(sAXXIncluder);
                try {
                    xIncludeFilter.setProperty("http://xml.org/sax/properties/lexical-handler", sAXXIncluder);
                    sAXXIncluder.setFilter(xIncludeFilter);
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
                xIncludeFilter.parse(stringArray[n]);
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace();
            }
            ++n;
        }
    }
}

