/*
 * Decompiled with CFR 0.152.
 */
package com.macfaq.xml;

import com.macfaq.xml.BadParseAttributeException;
import com.macfaq.xml.CircularIncludeException;
import com.macfaq.xml.EncodingHeuristics;
import com.macfaq.xml.MalformedResourceException;
import com.macfaq.xml.MissingHrefException;
import com.macfaq.xml.UnavailableResourceException;
import com.macfaq.xml.XIncludeException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class JDOMXIncluder {
    public static final Namespace XINCLUDE_NAMESPACE = Namespace.getNamespace((String)"xi", (String)"http://www.w3.org/2001/XInclude");
    private static SAXBuilder builder = new SAXBuilder();

    private JDOMXIncluder() {
    }

    public static Document resolve(Document document, String string) throws XIncludeException {
        Object object;
        if (document == null) {
            throw new NullPointerException("Document must not be null");
        }
        Document document2 = (Document)document.clone();
        Element element = document2.getRootElement();
        List list = JDOMXIncluder.resolve(element, string);
        Element element2 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object instanceof Element) {
                if (element2 != null) {
                    throw new XIncludeException("Tried to include multiple roots");
                }
                element2 = (Element)object;
                continue;
            }
            if (object instanceof Comment || object instanceof ProcessingInstruction) continue;
            if (object instanceof Text || object instanceof String) {
                throw new XIncludeException("Tried to include text node outside of root element");
            }
            if (object instanceof EntityRef) {
                throw new XIncludeException("Tried to include a general entity reference outside of root element");
            }
            throw new XIncludeException("Unexpected type " + object.getClass());
        }
        if (element2 == null) {
            throw new XIncludeException("No root element");
        }
        object = document2.getContent();
        iterator = list.iterator();
        int n = object.indexOf(document2.getRootElement());
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Comment || e instanceof ProcessingInstruction) {
                object.add(n, e);
                ++n;
                continue;
            }
            if (e instanceof Element) break;
        }
        document2.setRootElement(element2);
        int n2 = n + 1;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Comment) && !(e instanceof ProcessingInstruction)) continue;
            object.add(n2, e);
            ++n2;
        }
        return document2;
    }

    public static List resolve(Element element, String string) throws CircularIncludeException, XIncludeException, NullPointerException {
        if (element == null) {
            throw new NullPointerException("You can't XInclude a null element.");
        }
        Stack<String> stack = new Stack<String>();
        if (string != null) {
            stack.push(string);
        }
        List list = JDOMXIncluder.resolve(element, stack);
        stack.pop();
        return list;
    }

    private static boolean isIncludeElement(Element element) {
        return element.getName().equals("include") && element.getNamespace().equals((Object)XINCLUDE_NAMESPACE);
    }

    protected static List resolve(Element element, Stack stack) throws CircularIncludeException, MalformedResourceException, UnavailableResourceException, BadParseAttributeException, XIncludeException {
        String string = "";
        if (stack.size() != 0) {
            string = (String)stack.peek();
        }
        if (JDOMXIncluder.isIncludeElement(element)) {
            return JDOMXIncluder.resolveXIncludeElement(element, stack);
        }
        Element element2 = JDOMXIncluder.resolveNonXIncludeElement(element, stack);
        LinkedList<Element> linkedList = new LinkedList<Element>();
        linkedList.add(element2);
        return linkedList;
    }

    private static List resolveXIncludeElement(Element element, Stack stack) throws CircularIncludeException, MalformedResourceException, UnavailableResourceException, XIncludeException {
        String string;
        URL uRL;
        String string2 = "";
        if (stack.size() != 0) {
            string2 = (String)stack.peek();
        }
        if (!JDOMXIncluder.isIncludeElement(element)) {
            throw new RuntimeException("Bad private Call");
        }
        Attribute attribute = element.getAttribute("href");
        if (attribute == null) {
            throw new MissingHrefException("Missing href attribute");
        }
        Attribute attribute2 = element.getAttribute("base", Namespace.XML_NAMESPACE);
        if (attribute2 != null) {
            string2 = attribute2.getValue();
        }
        if (string2 != null) {
            try {
                URL uRL2 = new URL(string2);
                uRL = new URL(uRL2, attribute.getValue());
            }
            catch (MalformedURLException malformedURLException) {
                UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Unresolvable URL " + string2 + "/" + attribute);
                unavailableResourceException.setRootCause(malformedURLException);
                throw unavailableResourceException;
            }
        }
        try {
            uRL = new URL(attribute.getValue());
        }
        catch (MalformedURLException malformedURLException) {
            UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Unresolvable URL " + attribute.getValue());
            unavailableResourceException.setRootCause(malformedURLException);
            throw unavailableResourceException;
        }
        boolean bl = true;
        Attribute attribute3 = element.getAttribute("parse");
        if (attribute3 != null) {
            string = attribute3.getValue();
            if (string.equals("text")) {
                bl = false;
            } else if (!string.equals("xml")) {
                throw new BadParseAttributeException(attribute3 + "is not a legal value for the parse attribute");
            }
        }
        if (bl) {
            if (stack.contains(uRL.toExternalForm())) {
                throw new CircularIncludeException("Circular XInclude Reference to " + uRL.toExternalForm() + " in ");
            }
            try {
                string = builder.build(uRL);
                stack.push(uRL.toExternalForm());
                String string3 = uRL.getRef();
                Element element2 = string.getRootElement();
                List list = string.getContent();
                int n = list.indexOf(element2);
                List list2 = list.subList(0, n);
                List list3 = list.subList(n + 1, list.size());
                List list4 = JDOMXIncluder.resolve(element2, stack);
                LinkedList linkedList = new LinkedList();
                linkedList.addAll(list2);
                linkedList.addAll(list4);
                linkedList.addAll(list3);
                int n2 = 0;
                while (n2 < linkedList.size()) {
                    Element element3;
                    Object e = linkedList.get(n2);
                    if (e instanceof Element) {
                        element3 = (Element)e;
                        List list5 = JDOMXIncluder.resolve(element3, stack);
                        linkedList.addAll(n2, list5);
                        linkedList.remove(n2 += list5.size());
                        --n2;
                        element3.detach();
                    }
                    if (e instanceof Comment) {
                        element3 = (Comment)e;
                        element3.detach();
                    }
                    if (e instanceof ProcessingInstruction) {
                        element3 = (ProcessingInstruction)e;
                        element3.detach();
                    }
                    ++n2;
                }
                stack.pop();
                return linkedList;
            }
            catch (IOException iOException) {
                UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Unresolvable URL " + attribute.getValue());
                unavailableResourceException.setRootCause(iOException);
                throw unavailableResourceException;
            }
            catch (JDOMException jDOMException) {
                UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Unresolvable URL " + attribute.getValue());
                unavailableResourceException.setRootCause(jDOMException);
                throw unavailableResourceException;
            }
        }
        string = element.getAttributeValue("encoding");
        String string4 = JDOMXIncluder.downloadTextDocument(uRL, string);
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string4);
        return linkedList;
    }

    private static Element resolveNonXIncludeElement(Element element, Stack stack) throws CircularIncludeException, MalformedResourceException, UnavailableResourceException, XIncludeException {
        List list;
        String string = "";
        if (stack.size() != 0) {
            string = (String)stack.peek();
        }
        Element element2 = new Element(element.getName(), element.getNamespace());
        Iterator iterator = element.getAttributes().iterator();
        while (iterator.hasNext()) {
            list = (Attribute)iterator.next();
            element2.setAttribute((Attribute)list.clone());
        }
        list = element2.getContent();
        Iterator iterator2 = element.getContent().iterator();
        while (iterator2.hasNext()) {
            Element element3;
            Object e = iterator2.next();
            if (e instanceof Element) {
                element3 = (Element)e;
                if (JDOMXIncluder.isIncludeElement(element3)) {
                    list.addAll(JDOMXIncluder.resolveXIncludeElement(element3, stack));
                    continue;
                }
                list.add(JDOMXIncluder.resolveNonXIncludeElement(element3, stack));
                continue;
            }
            if (e instanceof String) {
                list.add(e);
                continue;
            }
            if (e instanceof Text) {
                list.add(e);
                continue;
            }
            if (e instanceof CDATA) {
                list.add(e);
                continue;
            }
            if (e instanceof Comment) {
                element3 = (Comment)e;
                list.add(element3.clone());
                continue;
            }
            if (e instanceof EntityRef) {
                element3 = (EntityRef)e;
                list.add(element3.clone());
                continue;
            }
            if (e instanceof ProcessingInstruction) {
                element3 = (ProcessingInstruction)e;
                list.add(element3.clone());
                continue;
            }
            throw new XIncludeException("Unexpected Type " + e.getClass());
        }
        return element2;
    }

    public static String downloadTextDocument(URL uRL, String string) throws UnavailableResourceException {
        if (string == null || string.equals("")) {
            string = "UTF-8";
        }
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            URLConnection uRLConnection = uRL.openConnection();
            String string2 = uRLConnection.getContentEncoding();
            String string3 = uRLConnection.getContentType();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
            if (string2 != null) {
                string = string2;
            } else if (string3 != null && ((string3 = string3.toLowerCase()).equals("text/xml") || string3.equals("application/xml") || string3.startsWith("text/") && string3.endsWith("+xml") || string3.startsWith("application/") && string3.endsWith("+xml"))) {
                string = EncodingHeuristics.readEncodingFromStream(bufferedInputStream);
            }
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, string);
            while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
                if (n == 60) {
                    stringBuffer.append("&lt;");
                    continue;
                }
                if (n == 38) {
                    stringBuffer.append("&amp;");
                    continue;
                }
                stringBuffer.append((char)n);
            }
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Encoding " + string + " not recognized for included document: " + uRL.toExternalForm());
            unavailableResourceException.setRootCause(unsupportedEncodingException);
            throw unavailableResourceException;
        }
        catch (IOException iOException) {
            UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Document not found: " + uRL.toExternalForm());
            unavailableResourceException.setRootCause(iOException);
            throw unavailableResourceException;
        }
    }

    public static void main(String[] stringArray) {
        SAXBuilder sAXBuilder = new SAXBuilder();
        XMLOutputter xMLOutputter = new XMLOutputter();
        int n = 0;
        while (n < stringArray.length) {
            try {
                Object object;
                Document document = sAXBuilder.build(stringArray[n]);
                String string = stringArray[n];
                if (string.indexOf(58) < 0) {
                    object = new File(string);
                    string = ((File)object).toURL().toExternalForm();
                }
                object = JDOMXIncluder.resolve(document, string);
                xMLOutputter.output((Document)object, (OutputStream)System.out);
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace();
            }
            ++n;
        }
    }
}

