/*
 * Decompiled with CFR 0.152.
 */
package com.macfaq.xml;

import com.macfaq.xml.BadParseAttributeException;
import com.macfaq.xml.CircularIncludeException;
import com.macfaq.xml.EncodingHeuristics;
import com.macfaq.xml.MalformedResourceException;
import com.macfaq.xml.MissingHrefException;
import com.macfaq.xml.UnavailableResourceException;
import com.macfaq.xml.XIncludeException;
import com.macfaq.xml.XIncludeNodeList;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMXIncluder {
    public static final String XINCLUDE_NAMESPACE = "http://www.w3.org/2001/XInclude";
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static DOMParser parser = new DOMParser();

    private DOMXIncluder() {
    }

    /*
     * Unable to fully structure code
     */
    public static Document resolve(Document var0, String var1_1) throws XIncludeException, NullPointerException {
        block10: {
            if (var0 == null) {
                throw new NullPointerException("Document must not be null");
            }
            var2_2 = (Document)var0.cloneNode(true);
            var3_3 = var2_2.getDocumentElement();
            var4_4 = DOMXIncluder.resolve(var3_3, var1_1, var2_2);
            var5_5 = 0;
            var6_6 = 0;
            while (var6_6 < var4_4.getLength()) {
                if (!(var4_4.item(var6_6) instanceof Comment) && !(var4_4.item(var6_6) instanceof ProcessingInstruction)) {
                    if (var4_4.item(var6_6) instanceof Element) {
                        ++var5_5;
                    } else {
                        if (var4_4.item(var6_6) instanceof Text) {
                            throw new XIncludeException("Tried to include text node outside document element");
                        }
                        throw new XIncludeException("Cannot include a " + var4_4.item(var6_6).getNodeType() + " node");
                    }
                }
                ++var6_6;
            }
            if (var5_5 != 1) {
                throw new XIncludeException("Tried to include multiple roots");
            }
            var7_7 = 0;
            while (var7_7 < var4_4.getLength()) {
                if (var4_4.item(var7_7) instanceof Element) break;
                var2_2.insertBefore(var4_4.item(var7_7), var3_3);
                ++var7_7;
            }
            var2_2.replaceChild(var4_4.item(var7_7), var3_3);
            ++var7_7;
            var8_8 = var2_2.getDocumentElement().getNextSibling();
            if (var8_8 != null) ** GOTO lbl41
            while (var7_7 < var4_4.getLength()) {
                var2_2.appendChild(var4_4.item(var7_7));
                ++var7_7;
            }
            break block10;
lbl-1000:
            // 1 sources

            {
                var2_2.insertBefore(var4_4.item(var7_7), var8_8);
                ++var7_7;
lbl41:
                // 2 sources

                ** while (var7_7 < var4_4.getLength())
            }
        }
        return var2_2;
    }

    public static NodeList resolve(Element element, String string, Document document) throws XIncludeException, NullPointerException {
        if (element == null) {
            throw new NullPointerException("You can't XInclude a null element.");
        }
        Stack<String> stack = new Stack<String>();
        if (string != null) {
            stack.push(string);
        }
        NodeList nodeList = DOMXIncluder.resolve(element, stack, document);
        stack.pop();
        return nodeList;
    }

    private static boolean isIncludeElement(Element element) {
        return element.getLocalName().equals("include") && element.getNamespaceURI().equals(XINCLUDE_NAMESPACE);
    }

    private static NodeList resolve(Element element, Stack stack, Document document) throws CircularIncludeException, MissingHrefException, MalformedResourceException, BadParseAttributeException, UnavailableResourceException, XIncludeException {
        XIncludeNodeList xIncludeNodeList = new XIncludeNodeList();
        String string = null;
        if (stack.size() != 0) {
            string = (String)stack.peek();
        }
        if (DOMXIncluder.isIncludeElement(element)) {
            String string2;
            Object object;
            if (!element.hasAttribute("href")) {
                throw new MissingHrefException("Missing href attribute");
            }
            String string3 = element.getAttribute("href");
            String string4 = element.getAttributeNS(XML_NAMESPACE, "base");
            if (string4 != null && !string4.equals("")) {
                string = string4;
            }
            if (string != null) {
                try {
                    URL uRL = new URL(string);
                    object = new URL(uRL, string3);
                    string2 = ((URL)object).toExternalForm();
                }
                catch (MalformedURLException malformedURLException) {
                    UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Unresolvable URL " + string + "/" + string3);
                    unavailableResourceException.setRootCause(malformedURLException);
                    throw unavailableResourceException;
                }
            } else {
                string2 = string3;
            }
            boolean bl = true;
            if (element.hasAttribute("parse")) {
                object = element.getAttribute("parse");
                if (((String)object).equals("text")) {
                    bl = false;
                } else if (!((String)object).equals("xml")) {
                    throw new BadParseAttributeException((String)object + "is not a legal value for the parse attribute");
                }
            }
            if (bl) {
                if (stack.contains(string2)) {
                    throw new CircularIncludeException("Circular XInclude Reference to " + string2 + " in ");
                }
                try {
                    parser.parse(string2);
                    object = parser.getDocument();
                    stack.push(string2);
                    NodeList nodeList = object.getChildNodes();
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        Node node = nodeList.item(n);
                        if (node instanceof Element) {
                            xIncludeNodeList.add(DOMXIncluder.resolve((Element)node, stack, document));
                        } else if (!(node instanceof DocumentType)) {
                            xIncludeNodeList.add(node);
                        }
                        ++n;
                    }
                    stack.pop();
                }
                catch (SAXParseException sAXParseException) {
                    int n = sAXParseException.getLineNumber();
                    int n2 = sAXParseException.getColumnNumber();
                    if (n <= 0) {
                        UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Document " + string2 + " was not found.");
                        unavailableResourceException.setRootCause(sAXParseException);
                        throw unavailableResourceException;
                    }
                    MalformedResourceException malformedResourceException = new MalformedResourceException("Document " + string2 + " is not well-formed at line " + n + ", column " + n2);
                    malformedResourceException.setRootCause(sAXParseException);
                    throw malformedResourceException;
                }
                catch (SAXException sAXException) {
                    MalformedResourceException malformedResourceException = new MalformedResourceException("Document " + string2 + " is not well-formed.");
                    malformedResourceException.setRootCause(sAXException);
                    throw malformedResourceException;
                }
                catch (IOException iOException) {
                    UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Document not found: " + string2);
                    unavailableResourceException.setRootCause(iOException);
                    throw unavailableResourceException;
                }
            } else {
                object = element.getAttribute("encoding");
                String string5 = DOMXIncluder.downloadTextDocument(string2, (String)object);
                xIncludeNodeList.add(document.createTextNode(string5));
            }
        } else {
            Element element2 = (Element)document.importNode(element, false);
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node instanceof Element) {
                    Element element3 = (Element)node;
                    NodeList nodeList2 = DOMXIncluder.resolve(element3, stack, document);
                    int n3 = 0;
                    while (n3 < nodeList2.getLength()) {
                        element2.appendChild(nodeList2.item(n3));
                        ++n3;
                    }
                } else {
                    element2.appendChild(document.importNode(node, true));
                }
                ++n;
            }
            xIncludeNodeList.add(element2);
        }
        return xIncludeNodeList;
    }

    private static String downloadTextDocument(String string, String string2) throws UnavailableResourceException {
        URL uRL;
        if (string2 == null || string2.equals("")) {
            string2 = "UTF-8";
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Unresolvable URL " + string);
            unavailableResourceException.setRootCause(malformedURLException);
            throw unavailableResourceException;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            URLConnection uRLConnection = uRL.openConnection();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
            String string3 = uRLConnection.getContentEncoding();
            String string4 = uRLConnection.getContentType();
            if (string3 != null) {
                string2 = string3;
            } else if (string4 != null && ((string4 = string4.toLowerCase()).equals("text/xml") || string4.equals("application/xml") || string4.startsWith("text/") && string4.endsWith("+xml") || string4.startsWith("application/") && string4.endsWith("+xml"))) {
                string2 = EncodingHeuristics.readEncodingFromStream(bufferedInputStream);
            }
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, string2);
            while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
                stringBuffer.append((char)n);
            }
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Encoding not recognized for document " + uRL.toExternalForm());
            unavailableResourceException.setRootCause(unsupportedEncodingException);
            throw unavailableResourceException;
        }
        catch (IOException iOException) {
            UnavailableResourceException unavailableResourceException = new UnavailableResourceException("Document not found: " + uRL.toExternalForm());
            unavailableResourceException.setRootCause(iOException);
            throw unavailableResourceException;
        }
    }

    public static void main(String[] stringArray) {
        DOMParser dOMParser = new DOMParser();
        int n = 0;
        while (n < stringArray.length) {
            try {
                Object object;
                dOMParser.parse(stringArray[n]);
                Document document = dOMParser.getDocument();
                String string = stringArray[n];
                if (string.indexOf(58) < 0) {
                    object = new File(string);
                    string = ((File)object).toURL().toExternalForm();
                }
                object = DOMXIncluder.resolve(document, string);
                OutputFormat outputFormat = new OutputFormat("XML", "ISO-8859-1", false);
                outputFormat.setPreserveSpace(true);
                XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)System.out, outputFormat);
                xMLSerializer.serialize((Document)object);
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace();
            }
            ++n;
        }
    }
}

